Imports System.Data

Partial Class ContentFiles_Default
    Inherits System.Web.UI.Page
    
    ''' <summary>
    ''' Ta procedura obsugi zdarzenia preinicjalizacyjnego jest uruchamiana 
    ''' w celu przeprowadzenia inicjalizacji. 
    ''' Pozwala ona okreli motyw i tytu strony, ktre s wydobywane z pliku 
    ''' web.config za porednictwem udostpnionych waciwoci wspuytkowanej klasy Config.
    ''' </summary>
    Protected Sub Page_PreInit(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.PreInit
        Page.Theme = Config.CurrentTheme
        Page.Title = Config.PageTitle
    End Sub

    ''' <summary>
    ''' Ta procedura obsugi zdarzenia Page_Load aduje kontrolk "tree view" z pokojami rozmw pogrupowanymi
    ''' w kategorie. 
    ''' </summary>
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Session("Email") = "" Then
            Server.Transfer("SignIn.aspx")
        End If


        If IsPostBack = False Then

            'pobierz pokoje rozmw w postaci dataset
            Dim dsChatRooms As DataSet
            dsChatRooms = ChatRoom.GetChatRoomList()
            Dim dtChatRoom As DataTable
            Dim currentRow As Integer = 0
            dtChatRoom = dsChatRooms.Tables(0)
            Dim drChatRoom As DataRow
            Dim lastCategoryID As Integer = 0

            'przejd kolejno po wierszach zestawu danych z pokojami rozmw 
            For Each drChatRoom In dtChatRoom.Rows

                'ustaw zmienne
                Dim CategoryId As Integer = _
                    dtChatRoom.Rows(currentRow).Item("CatID").ToString()
                Dim CategoryName As String = _
                    dtChatRoom.Rows(currentRow).Item("CatName").ToString()
                Dim RoomId As Integer = _
                    dtChatRoom.Rows(currentRow).Item("RoomID").ToString()
                Dim RoomName As String = _
                    dtChatRoom.Rows(currentRow).Item("RoomName").ToString()

                'sprawd identyfikatory nowych kategorii, dodaj tutaj wzy kategorii
                If CategoryId <> lastCategoryID Then
                    TreeView1.Nodes.Add(New TreeNode(CategoryName, CategoryId))
                End If
                currentRow = currentRow + 1
                lastCategoryID = CategoryId
            Next
            currentRow = 0

            'przejd kolejno po kadym wle
            For Each mNode As TreeNode In TreeView1.Nodes
                'pobierz tabel danych z wierszami odrbnie dla kadej kategorii
                For Each drChatRoom In dtChatRoom.Select("CatID=" & mNode.Value)
                    If Not drChatRoom.IsNull(0) Then
                        Dim RoomId As Integer = _
                            drChatRoom.Item("RoomID").ToString()
                        Dim RoomName As String = _
                            drChatRoom.Item("RoomName").ToString()
                        'dodaj wze pokoju rozmw pod t kategori
                        mNode.ChildNodes.Add(New _
                            TreeNode("<a href='chatroom.aspx?chatRoomID=" _
                             & RoomId.ToString() & "'>" & RoomName & "</a>", RoomId))
                    End If
                Next
            Next
        End If
    End Sub

End Class
